﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/psc.h>

#include "fgm_Hardware.test.h"

namespace nn     {
namespace fgm    {
namespace server {
namespace detail {
namespace        {

// Dummy CPU, GPU, EMC resources
TestResource cpuPM(nn::fgm::Module_Cpu);
TestResource gpuPM(nn::fgm::Module_Gpu);
TestResource emcPM(nn::fgm::Module_Emc);
TestResource testPM(nn::fgm::Module_Test);

} // namespace

nn::Result Initialize(nn::psc::PmModuleId** pDependencyList, uint32_t* pDependencyCount)
NN_NOEXCEPT
{
    nn::Result result;

    result = cpuPM.Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    result = gpuPM.Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    result = emcPM.Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    result = testPM.Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    *pDependencyList  = nullptr;
    *pDependencyCount = 0;

    return ResultSuccess();
}

}}}}
