﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

namespace nn { namespace fatalsrv {
    void*   Allocate(size_t size, size_t alignment, void* userPtr) NN_NOEXCEPT;
    void    Free(void* ptr, void* userPtr) NN_NOEXCEPT;
    void*   Reallocate(void* ptr, size_t size, void* userPtr) NN_NOEXCEPT;
    void    DumpHeapState(const char* title) NN_NOEXCEPT;

    void*   AllocateForFs(size_t size) NN_NOEXCEPT;
    void    FreeForFs(void* ptr, size_t size) NN_NOEXCEPT;
}} // namespace nn::fatalsrv
