﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/fontll/fontll_ScalableFontEngine.h>
#include "fatalsrv_Color.h"

namespace nn { namespace fatalsrv {

    class TextRenderer
    {
    public:

        Result Initialize(void* workBuffer, size_t workBufferSize, int bufferLengthOfLine) NN_NOEXCEPT;
        void SetDisplayBuffer(void* displayBuffer, int width, int height) NN_NOEXCEPT;
        uint32_t PutString(int x, int y, const char* format, ...) NN_NOEXCEPT;
        uint32_t PutChar(int x, int y, uint32_t charCode) NN_NOEXCEPT;
        void SetFontSize(int fontSize) NN_NOEXCEPT;
        void SetColor(const Color& r) NN_NOEXCEPT;
        void SetNewLineHeight(int height) NN_NOEXCEPT;
        void SetScaleX(float scaleX) NN_NOEXCEPT;
        void SetScaleY(float scaleY) NN_NOEXCEPT;

    private:
        void* m_pDisplayBuffer;
        int m_DisplayWidth;
        int m_DIsplayHeight;
        const void* m_pFont;
        int m_FontSize;
        nn::fontll::ScalableFontEngine m_FontEngine;
        char m_FontName[nn::fontll::FontNameLengthMax];
        Color m_Color;
        int m_NewLineHeight;
        float m_ScaleX;
        float m_ScaleY;
        void* m_pFontEngineBuffer;
        size_t m_FontEngineBufferSize;
        int m_Stride;
    };

    struct SharedFont
    {
        const void* pointer;
        size_t size;
    };

    void InitializeSharedFont() NN_NOEXCEPT;
    const SharedFont& GetSharedFont() NN_NOEXCEPT;
}} // namespace nn::fatalsrv
