﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fatal/detail/fatal_Log.h>
#include <nn/fatal/fatal_Result.h>
#include <nn/fatalsrv/fatalsrv_FatalEventManager.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include "fatalsrv_Memory.h"

#include <mutex>

namespace nn { namespace fatalsrv {

    FatalEventManager::FatalEventManager() NN_NOEXCEPT : m_CurrentCount(0), m_Lock(false)
    {
        for (int i = 0; i < MaxEventCount; ++i)
        {
            auto* event = new os::SystemEvent(os::EventClearMode_AutoClear, true);
            NN_ABORT_UNLESS_NOT_NULL(event);

            m_Events[i] = event;
        }
    }

    void FatalEventManager::Signal() NN_NOEXCEPT
    {
        for (int i = 0; i < MaxEventCount; ++i)
        {
            m_Events[i]->Signal();
        }
    }

    Result FatalEventManager::GetEvent(os::SystemEvent** out) NN_NOEXCEPT
    {
        std::lock_guard<os::Mutex> lock(m_Lock);

        NN_RESULT_THROW_UNLESS(m_CurrentCount < MaxEventCount, fatal::ResultTooManyFatalEventGot());
        *out = m_Events[m_CurrentCount];

        m_CurrentCount++;
        NN_RESULT_SUCCESS;
    }
}} // namespace nn::fatalsrv
