﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/fan/fan_ControlTypes.h>

#include "fan_FirmwareDebugSettingsAccessor.h"

namespace nn { namespace fan { namespace impl { namespace detail {

class SettingsHolder
{
public:
    enum class FanInterface
    {
        Invalid,
        Pwm,
        Gpio,
    };

public:
    SettingsHolder() NN_NOEXCEPT;

    //! settings からの設定の取得。
    void LoadSettings() NN_NOEXCEPT;

    //! ファンの存在フラグの取得。
    bool HasFan(FanName name) NN_NOEXCEPT;

    //! ファンインターフェースの取得。
    FanInterface GetFanInterface(FanName name) NN_NOEXCEPT;

private:
    NN_DISALLOW_COPY(SettingsHolder);
    NN_DISALLOW_MOVE(SettingsHolder);

private:
    //! CPU ファンの有効フラグ
    bool m_HasCpuFan;

    //! CPU ファンインターフェース
    FanInterface m_CpuFanInterface;

    //! Firmware Debug Settings にアクセスするためのオブジェクト。
    FirmwareDebugSettingsAccessor m_FirmwareDebugSettingsAccessor;
};

}}}} // namespace nn::fan::impl
