﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>
#include <nn/os.h>

#include <nn/nn_Common.h>

#include <nn/pwm/pwm.h>

#include <nn/fan/fan_ControlTypes.h>

#include "fan_DeviceAccessorBase.h"

namespace nn {
namespace fan {
namespace impl {
namespace detail {

class DeviceAccessorPwm : DeviceAccessor
{
    NN_DISALLOW_COPY(DeviceAccessorPwm);
    NN_DISALLOW_MOVE(DeviceAccessorPwm);

public:
    explicit DeviceAccessorPwm(FanName name) NN_NOEXCEPT;

    virtual int GetTargetRotationRate() const NN_NOEXCEPT;
    virtual int GetCurrentRotationRate() const NN_NOEXCEPT;
    virtual void SetTargetRotationRate(int rotationRate) NN_NOEXCEPT;
    virtual void SetFanEnabled(bool enabled) NN_NOEXCEPT;
    virtual void NotifyElapsedTime(int64_t elapsedTimeUsec) NN_NOEXCEPT;
    virtual void SetFanEnabledFromServer(bool enabled) NN_NOEXCEPT;

private:
    class RotationController
    {
    public:
        explicit RotationController(FanName name) NN_NOEXCEPT;
        ~RotationController() NN_NOEXCEPT;

        void InitializeRotation() NN_NOEXCEPT;
        void UpdateRotation(int targetRotationRate, int64_t elapsedTimeUsec) NN_NOEXCEPT;
        int GetCurrentRotationRate() const NN_NOEXCEPT;

    private:
        nn::pwm::ChannelSession m_ChannelSession;
        int     m_ActualRotationRate;
        int     m_RotationState;
        int64_t m_FragmentedElapsedTimeUsec;

        virtual void UpdateDutyRate() NN_NOEXCEPT;
    };

    int  m_TargetRotationRate;
    bool m_Enabled;
    nn::os::Mutex m_Mutex;
    RotationController m_RotationController;
    bool m_EnabledFromServer;
};

} // detail
} // impl
} // fan
} // nn
