﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/util/util_LockGuard.h>
#include <nn/eupld/sfdl/eupld.sfdl.h>
#include <nn/eupld/eupld_Result.h>
#include <nn/eupld/server/eupld_ServerApi.h>

#include "eupldsrv_IRequest.h"
#include "eupldsrv_IControl.h"

namespace nn    {
namespace eupld {
namespace srv   {

extern nn::sf::ExpHeapAllocator g_ServiceFrameworkAllocator;

nn::Result InitializeService()
NN_NOEXCEPT
{
    return ResultSuccess();
}

void WaitService()
NN_NOEXCEPT
{
    return;
}

}

bool                     g_Initialized = false;
nn::os::SdkMutex         g_Lock;
NN_ALIGNAS(4096) uint8_t g_UploadMemory[32 * 1024];

void StartEupldService()
NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(g_Lock);

    if (!g_Initialized)
    {
        nn::Result result = nn::eupld::srv::Initialize(g_UploadMemory, sizeof(g_UploadMemory));
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        g_Initialized = true;
    }
}

nn::Result GetRequestObject(nn::sf::SharedPointer<sf::IRequest> *pRequestObjectOut)
NN_NOEXCEPT
{
    StartEupldService();

    *pRequestObjectOut = nn::sf::ObjectFactory<
                           nn::sf::ExpHeapAllocator::Policy
                          >::CreateSharedEmplaced<
                           nn::eupld::sf::IRequest,
                           nn::eupld::srv::IRequest
                          >(&nn::eupld::srv::g_ServiceFrameworkAllocator);

    return *pRequestObjectOut ? ResultSuccess() : nn::eupld::ResultOutOfMemory();
}

nn::Result GetControlObject(nn::sf::SharedPointer<sf::IControl> *pControlObjectOut)
NN_NOEXCEPT
{
    StartEupldService();

    *pControlObjectOut = nn::sf::ObjectFactory<
                           nn::sf::ExpHeapAllocator::Policy
                          >::CreateSharedEmplaced<
                           nn::eupld::sf::IControl,
                           nn::eupld::srv::IControl
                          >(&nn::eupld::srv::g_ServiceFrameworkAllocator);

    return *pControlObjectOut ? ResultSuccess() : nn::eupld::ResultOutOfMemory();
}

}}
