﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/os/os_SdkMutex.H>
#include <nn/util/util_IntrusiveList.h>
#include <nn/erpt/erpt_Types.h>
#include <nn/eupld/eupld_Types.h>

#include "eupldsrv_Allocator.h"
#include "eupldsrv_RefCount.h"

namespace nn    {
namespace eupld {
namespace srv   {

enum RequestState
{
    RequestState_Scheduled,
    RequestState_UploadInProgress,
    RequestState_CancelInProgress,
    RequestState_Completed
};

class Request :
    public Allocator,
    public RefCount,
    public nn::util::IntrusiveListBaseNode<Request>
{
private:
    static nn::util::IntrusiveList<Request, nn::util::IntrusiveListBaseNodeTraits<Request>> m_RequestList;
    static nn::os::SdkMutex m_Lock;
    nn::os::SystemEvent*    m_pEvent;
    ReportUploadList        m_ReportList;
    RequestState            m_State;
    nn::Result              m_Result;
    bool                    m_Auto;

    void MarkAsUploaded()
    NN_NOEXCEPT;

public:
    static Request* GetRequest()
    NN_NOEXCEPT;

    bool IsAuto()
    NN_NOEXCEPT;

    nn::Result Cancel()
    NN_NOEXCEPT;

    nn::Result GetResult()
    NN_NOEXCEPT;

    ReportUploadList* GetUploadList()
    NN_NOEXCEPT;

    void CompleteRequest(nn::Result result)
    NN_NOEXCEPT;

    void Signal()
    NN_NOEXCEPT;

    nn::Result Initialize(const nn::erpt::ReportList& reportList, bool autoUpload)
    NN_NOEXCEPT;

    nn::Result Initialize(const nn::erpt::ReportId* pReportIdArray, uint32_t reportCount, bool autoUpload)
    NN_NOEXCEPT;

    void Finalize()
    NN_NOEXCEPT;

    explicit Request(nn::os::SystemEvent* pEvent)
    NN_NOEXCEPT;

    ~Request()
    NN_NOEXCEPT;
};

}}}
