﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/eupld/sfdl/eupld.sfdl.h>

namespace nn    {
namespace eupld {
namespace srv   {

class Request;

class IRequest :
    public nn::sf::ISharedObject
{

private:
    nn::os::SystemEvent m_SystemEvent;
    Request*            m_pRequestEntry;

public:
    nn::Result UploadAll()
    NN_NOEXCEPT;

    nn::Result UploadSelected(const nn::sf::InBuffer& reportIdArray)
    NN_NOEXCEPT;

    nn::Result GetUploadStatus(const nn::sf::OutBuffer& uploadList)
    NN_NOEXCEPT;

    nn::Result CancelUpload()
    NN_NOEXCEPT;

    nn::Result GetResult()
    NN_NOEXCEPT;

    nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut)
    NN_NOEXCEPT;

    IRequest()
    NN_NOEXCEPT;

    ~IRequest()
    NN_NOEXCEPT;
};

}}}
