﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/eupld/server/eupld_ResultForHttp.h>

#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace eupld { namespace srv {

inline Result HandleHttpStatusCode(long status) NN_NOEXCEPT
{
    const auto Category = status / 100;
    const auto Description = status % 100;
    if (Category == 2)
    {
        // 2xx は成功扱いにする
        NN_RESULT_SUCCESS;
    }

    switch (Category)
    {
    case 4:
        switch (Description)
        {
        case 0:
            NN_RESULT_THROW(ResultHttpStatus400BadRequest());
        case 1:
            NN_RESULT_THROW(ResultHttpStatus401Unauthorized());
        case 3:
            NN_RESULT_THROW(ResultHttpStatus403Forbidden());
        case 4:
            NN_RESULT_THROW(ResultHttpStatus404NotFound());
        case 5:
            NN_RESULT_THROW(ResultHttpStatus405MethodNotAllowed());
        case 6:
            NN_RESULT_THROW(ResultHttpStatus406NotAcceptable());
        case 7:
            NN_RESULT_THROW(ResultHttpStatus407ProxyAuthenticationRequired());
        case 8:
            NN_RESULT_THROW(ResultHttpStatus408RequestTimeout());
        case 9:
            NN_RESULT_THROW(ResultHttpStatus409Conflict());
        case 10:
            NN_RESULT_THROW(ResultHttpStatus410Gone());
        case 11:
            NN_RESULT_THROW(ResultHttpStatus411LengthRequired());
        case 12:
            NN_RESULT_THROW(ResultHttpStatus412PreconditionFailed());
        case 13:
            NN_RESULT_THROW(ResultHttpStatus413PayloadTooLarge());
        case 14:
            NN_RESULT_THROW(ResultHttpStatus414UriTooLong());
        case 15:
            NN_RESULT_THROW(ResultHttpStatus415UnsupportedMediaType());
        case 16:
            NN_RESULT_THROW(ResultHttpStatus416RangeNotSatisfiable());
        case 17:
            NN_RESULT_THROW(ResultHttpStatus417ExpectationFailed());
        default:
            NN_RESULT_THROW(ResultHttpStatus4xx());
        }
    case 5:
        switch (Description)
        {
        case 0:
            NN_RESULT_THROW(ResultHttpStatus500InternalServerError());
        case 1:
            NN_RESULT_THROW(ResultHttpStatus501NotImplemented());
        case 2:
            NN_RESULT_THROW(ResultHttpStatus502BadGateway());
        case 3:
            NN_RESULT_THROW(ResultHttpStatus503ServiceUnavailable());
        case 4:
            NN_RESULT_THROW(ResultHttpStatus504GatewayTimeout());
        case 5:
            NN_RESULT_THROW(ResultHttpStatus505HttpVersionNotSupported());
        default:
            NN_RESULT_THROW(ResultHttpStatus5xx());
        }
    default:
        NN_RESULT_THROW(ResultHttpUnsupportedStatusCode());
    }
} // NOLINT(readability/fn_size)

}}} // ~namespace nn::account::http
