﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/es/es_ELicenseTypesForInner.h>
#include <nn/es/es_TypesForInner.h>

namespace nn { namespace es {

ELicenseUserId GetELicenseUserId(const account::NintendoAccountId& naId) NN_NOEXCEPT
{
    return { naId.id };
}

account::NintendoAccountId GetNintendoAccountId(const ELicenseUserId& eLicenseUserId) NN_NOEXCEPT
{
    return { eLicenseUserId.id };
}

ELicenseOwnerId GetELicenseOwnerId(const account::NintendoAccountId& naId) NN_NOEXCEPT
{
    return { naId.id };
}

account::NintendoAccountId GetNintendoAccountId(const ELicenseOwnerId& eLicenseOwnerId) NN_NOEXCEPT
{
    return { eLicenseOwnerId.id };
}

ELicenseInfo GetELicenseInfo(ELicenseInfoForSystem eLicenseInfoForSystem) NN_NOEXCEPT
{
    ELicenseInfo eLicenseInfo = {};

    eLicenseInfo.eLicenseId = eLicenseInfoForSystem.eLicenseId;
    eLicenseInfo.rightsId = eLicenseInfoForSystem.rightsId;
    eLicenseInfo.ticketId = eLicenseInfoForSystem.ticketId;
    eLicenseInfo.ownerNaId = GetNintendoAccountId(eLicenseInfoForSystem.ownerNaId);
    eLicenseInfo.expireDate = eLicenseInfoForSystem.expireDate;
    eLicenseInfo.ticketOwnerVaId = eLicenseInfoForSystem.ticketOwnerVaId;
    eLicenseInfo.scope = eLicenseInfoForSystem.scope;

    return eLicenseInfo;
}

}}
