﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_ObjectFactory.h>
#include "es_CreateETicketService.h"
#include "es_ETicketServiceImpl.h"

namespace nn { namespace es {

namespace {
// 実装クラス ETicketServiceImpl を、IETicketService サービスオブジェクトとして参照できるようにします。
// nn::sf::UnmanagedServiceObject を使用します。
// テンプレート引数の 1 つ目にインターフェイス名を、 2 つ目にそのインターフェイスに対する内部実装を指定します。
// nn::sf::UnmanagedServiceObject 内で IETicketService インターフェイスと内部実装 ETicketServiceImpl の紐付けが行われ、サービスオブジェクト経由での機能へのアクセスが行えるようになります。
nn::sf::UnmanagedServiceObject<IETicketService, ETicketServiceImpl> g_ETicketService;
}

// 機能へのアクセスは共有ポインタを利用します。
// 共有ポインタを返却する関数を作成し、サービス利用者はその関数で得られた共有ポインタを利用して、機能にアクセスします。
nn::sf::SharedPointer<IETicketService> CreateETicketServiceByDfc() NN_NOEXCEPT
{
    // nn::sf::UnmanagedServiceObject の場合は GetShared() メソッドで共有ポインタを取得することができます。
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ETicketService.GetImpl().InitializeFile());
    return g_ETicketService.GetShared();
}

}}  // namespace nn::es
