﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/err/err_Types.h>
#include <nn/ns/ns_ApplicationManagerApi.h>

namespace nn { namespace err { namespace detail {

void MakeErrorCodeString(char* outValue, size_t outValueSize, ErrorCode errorCode) NN_NOEXCEPT;
void MakeApplicationErrorCodeString(char* outValue, size_t outValueSize, const ns::ApplicationErrorCodeCategory& category, ApplicationErrorCodeNumber number) NN_NOEXCEPT;
void ParseErrorCodeString(ErrorCode* outValue, const char* errorCodeString) NN_NOEXCEPT;
void ParseApplicationErrorCodeString(ns::ApplicationErrorCodeCategory* outCategory, ApplicationErrorCodeNumber* outNumber, const char* applicationErrorCodeString) NN_NOEXCEPT;
bool IsApplicationErrorCodeString(const char* errorCodeString) NN_NOEXCEPT;

bool TryParseErrorCodeString(ErrorCode* outValue, const char* errorCodeStr) NN_NOEXCEPT;
bool TryParseApplicationErrorCodeString(ns::ApplicationErrorCodeCategory* outCategory, ApplicationErrorCodeNumber* outNumber, const char* applicationErrorCodeStr) NN_NOEXCEPT;

}}}
