﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/erpt/server/erpt_ServerTypes.h>

#include "erptsrv_Allocator.h"
#include "erptsrv_RefCount.h"
#include "erptsrv_JournalRecord.h"

namespace nn   {
namespace erpt {
namespace srv  {

const uint32_t JournalStreamBufferSize = (4 * 1024);
const int      JournalVersion = 1;

struct JournalMeta
{
    int        version;
    uint32_t   transmittedCount[ReportType_Last];
    uint32_t   untransmittedCount[ReportType_Last];
    util::Uuid journalId;
    uint32_t   reserved[4];
};
NN_STATIC_ASSERT(sizeof(JournalMeta) == 52);

class Journal
{
private:
    static nn::util::IntrusiveList<
                    JournalRecord, nn::util::IntrusiveListBaseNodeTraits<JournalRecord>
                  > m_RecordList;
    static uint32_t m_RecordCount;
    static uint32_t m_RecordCountPerType[ReportType_Last];
    static uint32_t m_UsedStorage;

    static JournalMeta m_JournalMeta;

public:
    static JournalRecord* Retrieve(ReportId reportId)
    NN_NOEXCEPT;

    static nn::Result Store(JournalRecord* pRecord)
    NN_NOEXCEPT;

    static nn::Result GetReportList(ReportList* pReportList, ReportType filterType)
    NN_NOEXCEPT;

    static nn::Result Commit()
    NN_NOEXCEPT;

    static nn::Result Restore()
    NN_NOEXCEPT;

    static void CleanupReports()
    NN_NOEXCEPT;

    static nn::Result Delete(ReportId reportId)
    NN_NOEXCEPT;

    static uint32_t GetTransmittedCount(ReportType type)
    NN_NOEXCEPT;

    static uint32_t GetUnstransmittedCount(ReportType type)
    NN_NOEXCEPT;

    static util::Uuid GetJournalId()
    NN_NOEXCEPT;

    static uint32_t GetStoredReportCount(ReportType type)
    NN_NOEXCEPT;

    static int64_t GetMaxReportSize()
    NN_NOEXCEPT;

    static uint32_t GetUsedStorage()
    NN_NOEXCEPT;
};

}}}
