﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/erpt/erpt_Result.h>
#include <nn/erpt/server/erpt_ServerTypes.h>
#include <nn/util/util_IntrusiveList.h>

#include "erptsrv_Allocator.h"

namespace nn   {
namespace erpt {
namespace srv  {

class Context;

class ContextRecord :
    public Allocator,
    public nn::util::IntrusiveListBaseNode<ContextRecord>
{
    friend Context;

private:
    ContextEntry    m_Context;
    static uint32_t m_ContextRecordCount;

public:
    nn::Result Initialize(const ContextEntry* pContext, const uint8_t* pData, uint32_t dataLength)
    NN_NOEXCEPT;

    nn::Result Add(FieldId id, bool valueBool)
    NN_NOEXCEPT;

    nn::Result Add(FieldId id, uint64_t valueU64)
    NN_NOEXCEPT;

    nn::Result Add(FieldId id, uint32_t valueU32)
    NN_NOEXCEPT;

    nn::Result Add(FieldId id, int64_t valueI64)
    NN_NOEXCEPT;

    nn::Result Add(FieldId id, int32_t valueI32)
    NN_NOEXCEPT;

    nn::Result Add(FieldId id, const char* pBuffer, uint32_t bufferLength)
    NN_NOEXCEPT;

    static uint32_t GetRecordCount()
    NN_NOEXCEPT;

    ContextRecord()
    NN_NOEXCEPT;

    explicit ContextRecord(CategoryId category)
    NN_NOEXCEPT;

    ~ContextRecord()
    NN_NOEXCEPT;
};

}}}
