﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/eclct/detail/eclct_Log.h>

#define NN_DETAIL_ECLCT_WARN_UNLESS_RESULT_SUCCESS(expression) \
    do \
    { \
        auto result = (expression); \
        if ( result.IsFailure() ) \
        { \
            NN_DETAIL_ECLCT_WARN("Failed: %s\n  Module: %d\n  Description: %d\n  InnerValue: 0x%08x\n", \
                NN_MACRO_STRINGIZE(expression), result.GetModule(), result.GetDescription(), result.GetInnerValueForDebug()); \
        } \
    } while ( NN_STATIC_CONDITION(false) )
