﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief クライアントにおける消費型サービスアイテムの権利の型を定義します。
 */

#include <type_traits>
#include <nn/ec/ec_ConsumableServiceItemTypes.h>
#include <nn/util/util_Utf8StringUtil.h>
#include "ec_ConsumableServiceItemInternalTypes.h"

#define INVALID_UNLESS(expression) \
    do { auto _r = (expression); if (!_r) return false; } while (NN_STATIC_CONDITION(false))

namespace
{
//! NULL 終端判定
bool IsNullTerminatedString(const char value[], int valueSize) NN_NOEXCEPT
{
    int length = nn::util::Strnlen(value, valueSize);
    return (length < valueSize && value[length] == '\0');
}
}

namespace nn { namespace ec {

NN_STATIC_ASSERT(std::is_trivially_copyable<ConsumableServiceItemRightDataImpl>::value);
NN_STATIC_ASSERT(std::is_trivially_copyable<ConsumableServiceItemRightData>::value);
NN_STATIC_ASSERT(NN_ALIGNOF(ConsumableServiceItemRightDataImpl) == NN_ALIGNOF(ConsumableServiceItemRightData));
NN_STATIC_ASSERT(sizeof(ConsumableServiceItemRightDataImpl) == sizeof(ConsumableServiceItemRightData));

bool ConsumableServiceItemId::IsValid() const NN_NOEXCEPT
{
    return (nn::util::Strnlen(value, Length + sizeof('\0')) > 0);
}

bool ConsumableServiceItemRightData::IsValid() const NN_NOEXCEPT
{
    auto& info = nn::util::Get(value);

    //! NULL 終端判定
    INVALID_UNLESS(IsNullTerminatedString(info.rightId.value, sizeof(info.rightId.value)));
    INVALID_UNLESS(IsNullTerminatedString(info.consumptionRequestId.value, sizeof(info.consumptionRequestId.value)));
    return true;
}

ConsumableServiceItemId ConsumableServiceItemRightData::GetConsumableServiceItemId() const NN_NOEXCEPT
{
    auto& info = nn::util::Get(value);
    return info.itemId;
}

bool ConsumableServiceItemRightData::IsServiceProvidableOnLocal() const NN_NOEXCEPT
{
    auto& info = nn::util::Get(value);
    return info.isServiceProvidableOnLocal;
}

}}
