﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/dns/parser.h>
#include "dns_ParserMacros.h"

extern "C"
{
#include <nnc/dns/parser.h>

int nndnsparserQuestionIteratorInitialize(struct nndnsparserQuestionIterator* pIterator,
                                          const struct nndnsparserMessage* pMessage,
                                          nndnsparserMessageSectionConstant tag)
{
    int rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pIterator, bail);
    NN_DNSPARSER_ERROR_IF(nullptr == pMessage, bail);

    {
        auto object = reinterpret_cast<nn::dns::parser::QuestionIterator*>(pIterator);
        auto m = reinterpret_cast<const nn::dns::parser::Message&>(*pMessage);
        auto t = static_cast<nn::dns::parser::MessageSectionConstant>(tag);
        rc = object->Initialize(m, t);
    };

bail:
    return rc;
};

int nndnsparserQuestionIteratorGetNext(struct nndnsparserQuestionIterator* pIterator)
{
    int rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pIterator, bail);

    {
        auto object = reinterpret_cast<nn::dns::parser::QuestionIterator*>(pIterator);
        rc = object->GetNext();
    };

bail:
    return rc;
};

}; // extern "C"
