﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/dns/parser.h>
#include "dns_ParserMacros.h"

extern "C"
{
#include <nnc/dns/parser.h>

void nndnsparserMessageInitialize(struct nndnsparserMessage* pMessage)
{
    NN_DNSPARSER_ERROR_IF(nullptr == pMessage, bail);

    {
        auto object = reinterpret_cast<nn::dns::parser::Message*>(pMessage);
        object->Initialize();
    };

bail:
    return;
};

ssize_t nndnsparserMessageSizeOf(const struct nndnsparserMessage* pMessage)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pMessage, bail);

    {
        auto object = reinterpret_cast<const nn::dns::parser::Message*>(pMessage);
        rc = object->SizeOf();
    };

bail:
    return rc;
};

bool nndnsparserMessageIsEqual(const struct nndnsparserMessage* pMessage1,
                               const struct nndnsparserMessage* pMessage2)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pMessage1, bail);
    NN_DNSPARSER_ERROR_IF(nullptr == pMessage2, bail);

    {
        auto p = reinterpret_cast<const nn::dns::parser::Message*>(pMessage1);
        auto q = reinterpret_cast<const nn::dns::parser::Message*>(pMessage2);
        rc = (*p) == (*q);
    };

bail:
    return rc;
};

ssize_t nndnsparserMessageFromBuffer(struct nndnsparserMessage* pMessage,
                                     const uint8_t* pBuffer,
                                     size_t size)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pMessage, bail);

    {
        auto object = reinterpret_cast<nn::dns::parser::Message*>(pMessage);
        rc = object->FromBuffer(pBuffer, size);
    };

bail:
    return rc;
};

ssize_t nndnsparserMessageToBuffer(uint8_t * const pBuffer,
                                   size_t size,
                                   const struct nndnsparserMessage* pMessage)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pMessage, bail);

    {
        auto object = reinterpret_cast<const nn::dns::parser::Message*>(pMessage);
        rc = object->ToBuffer(pBuffer, size);
    };

bail:
    return rc;
};

}; // extern "C"
