﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/dns/parser.h>
#include "dns_ParserMacros.h"

extern "C"
{
#include <nnc/dns/Parser.h>

bool nndnsparserMemoryBlockIsEqual(const struct nndnsparserMemoryBlock* pBlock1,
                                   const struct nndnsparserMemoryBlock* pBlock2) NN_NOEXCEPT
{
    auto p = reinterpret_cast<const nn::dns::parser::MemoryBlock*>(pBlock1);
    auto q = reinterpret_cast<const nn::dns::parser::MemoryBlock*>(pBlock2);
    return nn::dns::parser::MemoryBlockIsEqual(p, q);
};

int nndnsparserCreateInaddrArpaString(char* pArpaBuffer,
                                      size_t size,
                                      uint32_t ipAddress)
{
    return nn::dns::parser::CreateInaddrArpaString(pArpaBuffer, size, ipAddress);
};

}; //extern "C"
