﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "detail/dhcps_LibraryThread.h"
#include "detail/dhcps_LeaseTableManager.h"

//#define NN_DETAIL_DHCPS_LOG_LEVEL NN_DETAIL_DHCPS_LOG_LEVEL_DEBUG
#define NN_DETAIL_DHCPS_LOG_MODULE_NAME "PublicApi"
#include "detail/dhcps_Log.h"

namespace nn { namespace dhcps {

namespace detail {
const char* LibraryThreadStateToString(detail::LibraryThread::State in);
};

detail::LibraryThread g_LibraryThread;

/**
 * Functions that control the library
 */

Result Initialize(const UserConfiguration& userConfig) NN_NOEXCEPT
{
    return g_LibraryThread.Initialize(userConfig);
};

Result GetMemorySize(size_t* pOutSize) NN_NOEXCEPT
{
    return g_LibraryThread.GetMemorySize(pOutSize);
};

Result SetMemory(void* pMemory, size_t size) NN_NOEXCEPT
{
    return g_LibraryThread.SetMemory(pMemory, size);
};

Result Start() NN_NOEXCEPT
{
    return g_LibraryThread.Start();
};

Result Stop() NN_NOEXCEPT
{
    return g_LibraryThread.Stop();
};

Result Finalize() NN_NOEXCEPT
{
    return g_LibraryThread.Finalize();
};

/**
 * Informational functions
 */

Result GetLeaseByDhcpClientIdentifierHash(DhcpLease* pOutLease, ClientIdentifierHash clientId) NN_NOEXCEPT
{
    return g_LibraryThread.GetLeaseByDhcpClientIdentifierHash(pOutLease, clientId);
};

Result GetLeaseByInternetAddress(DhcpLease* pOutLease, nn::socket::InAddr ipAddress) NN_NOEXCEPT
{
    return g_LibraryThread.GetLeaseByInternetAddress(pOutLease, ipAddress);
};

Result GetLeaseByEthernetMacAddress(DhcpLease* pOutLease, const EthernetMacAddress& macAddress) NN_NOEXCEPT
{
    return g_LibraryThread.GetLeaseByEthernetMacAddress(pOutLease, macAddress);
};

const char* StateToString(State in) NN_NOEXCEPT
{
    switch (in)
    {
        NN_DETAIL_DHCPS_STRINGIFY_CASE(State::Unbound);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(State::Offered);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(State::Bound);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(State::Renewing);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(State::Rebinding);
    default:
        ;
    };

    return "Unknown DhcpState";
};

const char* EventToString(Event in) NN_NOEXCEPT
{
    switch (in)
    {
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnStart);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnRunning);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnStopping);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnStopped);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnDetectedNetworkChange);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnRecoverableError);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnUnrecoverableError);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseOffered);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseOfferResent);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseOfferAdvancedState);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseOfferExpired);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseOfferReused);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseDecline);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseDeclineInvalid);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseInform);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseInformInvalid);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseRenewing);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseRequest);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseRequestInvalid);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseRebinding);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseExpired);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseRelease);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnLeaseReleaseInvalid);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnTableFull);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnTableAvailable);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnDiscoverWhileTableFull);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(Event::OnDhcpUnhandledMessage);
    default:
        ;
    };

    return "Unknown Event";
};

}}; // nn::dhcps::detail
