﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "dhcps_GlobalState.h"

//#define NN_DETAIL_DHCPS_LOG_LEVEL NN_DETAIL_DHCPS_LOG_LEVEL_DEBUG
#define NN_DETAIL_DHCPS_LOG_MODULE_NAME "GlobalState"
#include "dhcps_Log.h"

namespace nn { namespace dhcps { namespace detail {

uint8_t g_GlobalState[static_cast<size_t>(GlobalState::Max)] = { 0 };

const char* GlobalStateIdentifierToString(GlobalState id) NN_NOEXCEPT
{
    switch (id)
    {
        NN_DETAIL_DHCPS_STRINGIFY_CASE(GlobalState::Thread);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(GlobalState::Coordinator);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(GlobalState::BpfManager);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(GlobalState::ProtocolStack);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(GlobalState::DhcpManager);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(GlobalState::LeaseTableManager);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(GlobalState::UdpSocketManager);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(GlobalState::Max);
    default:
        ;
    }

    return "Unknown GlobalState";
};


void SetGlobalState(GlobalState id, uint8_t u8Value) NN_NOEXCEPT
{
    g_GlobalState[static_cast<int>(id)] = u8Value;

    NN_DETAIL_DHCPS_LOG_DEBUG("id: %s (%d) g_GlobalState: "
                                   "%02x%02x%02x%02x%02x%02x%02x\n",
                                   GlobalStateIdentifierToString(id),
                                   id,
                                   g_GlobalState[0], g_GlobalState[1],
                                   g_GlobalState[2], g_GlobalState[3],
                                   g_GlobalState[4], g_GlobalState[5],
                                   g_GlobalState[6]);
};

uint8_t GetGlobalState(GlobalState id) NN_NOEXCEPT
{
    if (id >= GlobalState::Max)
        return -1;
    return g_GlobalState[static_cast<int>(id)];
};

}}}; //nn::dhcps::detail
