﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <curl/curl.h>

#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/util/util_Execution.h>

namespace nn { namespace dauth { namespace detail {

class NdasDriver
{
    NN_DISALLOW_COPY(NdasDriver);
    NN_DISALLOW_MOVE(NdasDriver);

public:
    static const size_t RequiredWorkBufferSize = 8 * 1024;

    static Result AcquireDeviceAuthenticationToken(
        TimeSpan* pOutExpiration, int* pOutLength, char* tokenBuffer, size_t tokenBufferSize,
        uint64_t clientId, CURL* pCurlHandle, void* workBuffer, size_t workBufferSize, const util::Cancelable* pCancelable) NN_NOEXCEPT;

    static Result AcquireEdgeToken(
        TimeSpan* pOutExpiration, int* pOutLength, char* tokenBuffer, size_t tokenBufferSize,
        uint64_t clientId, CURL* curlHandle, void* workBuffer, size_t workBufferSize, const util::Cancelable* pCancelable) NN_NOEXCEPT;
};

}}} // ~namespace nn::dauth::detail
