﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/codec/detail/codec_HardwareOpusCommon-spec.NX.h>
#include <nn/codec/server/codec_HardwareOpusDecoderHipcServer.h>

#include <nn/sf/sf_HipcServer.h>


#include "../detail/codec_ServiceName.h"
#include "../codec_CreateHardwareOpusDecoderManager.h"


namespace nn { namespace codec { namespace server {

namespace {

// テンプレートの第1引数に指定する数に達すると以下の Abort が発生するので、"+ 1" しておく。
// Programs\Chris\Sources\Libraries\sf\hipc\server/sf_HipcServerMessage.h(428)
// Failed: m_pDomain->Register(serverSessionHandle, std::move(outObject))
//   Module: 11
//   Description: 102
//   InnerValue: 0x0000cc0b
struct MyServerManagerOption
{
    static const size_t PointerTransferBufferSize = 4096;
};
class MyServerManager : public nn::sf::HipcSimpleAllInOneServerManager<detail::HardwareOpusDecoderIpcConstants_SessionCountMax + 1, 1, MyServerManagerOption>
{
};

std::aligned_storage<sizeof(MyServerManager), NN_ALIGNOF(MyServerManager)>::type g_MyServerManagerStorage;
MyServerManager* g_pMyServerManager;

}  // namespace anonymous

void InitializeHardwareOpusDecoderServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pMyServerManager == nullptr);

    g_pMyServerManager = new (&g_MyServerManagerStorage) MyServerManager;
    auto sessionCountMax = detail::HardwareOpusDecoderIpcConstants_SessionCountMax; // ここは "+ 1" しなくて良さそう。
                                                                                    // と言うか、1 でも良かった (0 は NG)。
    g_pMyServerManager->RegisterObjectForPort(CreateHardwareOpusDecoderManagerByDfc(), sessionCountMax, CodecHardwareOpusDecoderServiceName);
}

void StartHardwareOpusDecoderServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pMyServerManager != nullptr);
    g_pMyServerManager->Start();
}

void LoopHardwareOpusDecoderServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(g_pMyServerManager);
    g_pMyServerManager->LoopAuto();
}

void RequestStopHardwareOpusDecoderServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(g_pMyServerManager);
    g_pMyServerManager->RequestStop();
}

void FinalizeHardwareOpusDecoderServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(g_pMyServerManager);
    g_pMyServerManager->~MyServerManager();
    g_pMyServerManager = nullptr;
}

}}} // namespace nn::codec::server
