﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#if defined(_NX_CODEC_DSP_)
#include <os/kernel/thread.h>
#endif // defined(_NX_CODEC_DSP_)

#include "codec_UtilMailbox.h"

namespace nn { namespace codec { namespace dsp {

bool MboxWrapper::Open(int mailboxId)
{
    if ( !IsAvailable() )
    {
        m_MailboxId = mailboxId;
#if defined(_NX_CODEC_DSP_)
        m_LastStatus = mbx_open(&m_Mailbox, &m_MailboxId, NULL, NULL, NULL, NULL, &m_Mailbox);
#else  // TARGET_CPU
        m_LastStatus = nne::audio::adsp::Mbox::MboxOpen(&m_Mailbox, &m_MailboxId, NULL, NULL, NULL, NULL, NULL);
#endif
        if ( MailboxStatusNoError == m_LastStatus )
        {
#if defined(_NX_CODEC_DSP_)
            mbx_attr(&m_Mailbox, ADSP_MBX_OWNER_ONLY, false);
#endif
            m_IsAvailable = true;
        }
    }
    return m_IsAvailable;
}

void MboxWrapper::Close()
{
    if ( IsAvailable() )
    {
#if defined(_NX_CODEC_DSP_)
        mbx_close(&m_Mailbox);
#else  // TARGET_CPU
        nne::audio::adsp::Mbox::MboxClose(&m_Mailbox);
#endif
        m_IsAvailable = false;
    }
}

bool MboxWrapper::SendData(int data, int64_t timeoutInMilli)
{
#if defined(_NX_CODEC_DSP_)
    m_LastStatus = mbx_send_msg(&m_Mailbox, data, false, 0);
#else  // TARGET_CPU
    m_LastStatus = nne::audio::adsp::Mbox::MboxSendMsg(
            &m_Mailbox, data, true, nn::TimeSpan::FromMilliSeconds(timeoutInMilli));
#endif
    return m_LastStatus == MailboxStatusNoError;
}

bool MboxWrapper::ReceiveData(int* pData, int64_t timeoutInMilli)
{
#if defined(_NX_CODEC_DSP_)
    m_LastStatus = mbx_recv_msg(&m_Mailbox, pData, true, INFINITE_TIME);
#else  // TARGET_CPU
    m_LastStatus = nne::audio::adsp::Mbox::MboxRecvMsg(
            &m_Mailbox, pData, true, nn::TimeSpan::FromMilliSeconds(timeoutInMilli));
#endif
    return m_LastStatus == MailboxStatusNoError;
}

int  MboxWrapper::GetLastError()
{
#if defined(_NX_CODEC_DSP_)
    int lastError = mbx_get_err_code(&m_Mailbox);
    mbx_clear_err_code(&m_Mailbox);
#else  // TARGET_CPU
    int lastError = nne::audio::adsp::Mbox::MboxGetErrCode(&m_Mailbox);
    nne::audio::adsp::Mbox::MboxClearErrCode(&m_Mailbox);
#endif
    return lastError;
}

}}} // nn::codec::dsp
