﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os/os_TransferMemory.h>

#include "codec_HardwareOpusDecoderManagerImpl.h"
#include "detail/codec_HardwareOpusDecoderImpl-spec.NX.h"

namespace nn { namespace codec {

class HardwareOpusDecoderManagerImpl::HardwareOpusDecoderImpl
{
public:
    HardwareOpusDecoderImpl() NN_NOEXCEPT
        : m_TransferMemory()
        , m_IsTransferMemoryMapped(false)
        , m_DecoderImpl()
    {
    }

    ~HardwareOpusDecoderImpl() NN_NOEXCEPT
    {
        if (m_DecoderImpl.IsInitialized())
        {
            m_DecoderImpl.Finalize();
        }
        if(m_IsTransferMemoryMapped)
        {
            m_TransferMemory.Unmap();
        }
    }

    nn::Result Initialize(
        const detail::HardwareOpusDecoderParameterInternal& parameter,
        nn::sf::NativeHandle& sfHandle,
        int workBufferSize) NN_NOEXCEPT;

    nn::Result DecodeInterleavedOld(
        nn::sf::Out<int> pOutConsumed,
        nn::sf::Out<int> pOutSampleCount,
        const nn::sf::OutBuffer& outputBuffer,
        const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT;

    nn::Result DecodeInterleavedWithPerfOld(
        nn::sf::Out<int> pOutConsumed,
        nn::sf::Out<int64_t> pPerf,
        nn::sf::Out<int> pOutSampleCount,
        const nn::sf::OutBuffer& outputBuffer,
        const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT;

    nn::Result DecodeInterleaved(
        nn::sf::Out<int> pOutConsumed,
        nn::sf::Out<int64_t> pPerf,
        nn::sf::Out<int> pOutSampleCount,
        const nn::sf::OutBuffer& outputBuffer,
        const nn::sf::InBuffer& inputBuffer,
        bool isResetRequested) NN_NOEXCEPT;

    nn::Result SetContext(const nn::sf::InBuffer& context) NN_NOEXCEPT;

    nn::Result InitializeForMultiStream(
        const detail::HardwareOpusMultiStreamDecoderParameterInternal& parameter,
        nn::sf::NativeHandle& sfHandle,
        int workBufferSize) NN_NOEXCEPT;

    nn::Result DecodeInterleavedForMultiStreamOld(
        nn::sf::Out<int> pOutConsumed,
        nn::sf::Out<int> pOutSampleCount,
        const nn::sf::OutBuffer& outputBuffer,
        const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT;

    nn::Result DecodeInterleavedForMultiStreamWithPerfOld(
        nn::sf::Out<int> pOutConsumed,
        nn::sf::Out<int64_t> pOutPerf,
        nn::sf::Out<int> pOutSampleCount,
        const nn::sf::OutBuffer& outputBuffer,
        const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT;

    nn::Result DecodeInterleavedForMultiStream(
        nn::sf::Out<int> pOutConsumed,
        nn::sf::Out<int64_t> pOutPerf,
        nn::sf::Out<int> pOutSampleCount,
        const nn::sf::OutBuffer& outputBuffer,
        const nn::sf::InBuffer& inputBuffer,
        bool isResetRequested) NN_NOEXCEPT;

    nn::Result SetContextForMultiStream(const nn::sf::InBuffer& context) NN_NOEXCEPT;

private:
    nn::os::TransferMemory m_TransferMemory;
    bool m_IsTransferMemoryMapped;
    nn::codec::detail::HardwareOpusDecoderImpl m_DecoderImpl;
};

}}  // namespace nn::codec
