﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/codec/codec_AacDecoderTypes.h>

#include "aacdecoder_lib.h"

namespace nn { namespace codec {

AacDecoderResult ConvertToAacDecoderResult(AAC_DECODER_ERROR error) NN_NOEXCEPT
{
    switch (error)
    {
        case AAC_DEC_OK:
            return AacDecoderResult_Success;
        case AAC_DEC_OUT_OF_MEMORY:
            return AacDecoderResult_OutOfMemory;
        case AAC_DEC_UNKNOWN:
            return AacDecoderResult_InternalError;
        case AAC_DEC_TRANSPORT_SYNC_ERROR:
            return AacDecoderResult_InputBitstreamCorrupted;
        case AAC_DEC_NOT_ENOUGH_BITS:
            return AacDecoderResult_NotEnoughBits;
        case AAC_DEC_INVALID_HANDLE:
            return AacDecoderResult_InvalidHandle;
        case AAC_DEC_UNSUPPORTED_AOT:
            return AacDecoderResult_UnsupportedAudioObjectType;
        case AAC_DEC_UNSUPPORTED_FORMAT:
            return AacDecoderResult_UnsupportedFormat;
        case AAC_DEC_UNSUPPORTED_ER_FORMAT:
            return AacDecoderResult_UnsupportedFormat;
        case AAC_DEC_UNSUPPORTED_EPCONFIG:
            return AacDecoderResult_UnsupportedFormat;
        case AAC_DEC_UNSUPPORTED_MULTILAYER:
            return AacDecoderResult_UnsupportedFormat;
        case AAC_DEC_UNSUPPORTED_CHANNELCONFIG:
            return AacDecoderResult_UnsupportedChannelConfig;
        case AAC_DEC_UNSUPPORTED_SAMPLINGRATE:
            return AacDecoderResult_UnsupportedSampleRate;
        case AAC_DEC_INVALID_SBR_CONFIG:
            return AacDecoderResult_InputBitstreamCorrupted;
        case AAC_DEC_SET_PARAM_FAIL:
            return AacDecoderResult_InvalidParameter;
        case AAC_DEC_NEED_TO_RESTART:
            return AacDecoderResult_ReinitializationRequired;
        case AAC_DEC_OUTPUT_BUFFER_TOO_SMALL:
            return AacDecoderResult_OutputBufferTooSmall;
        case AAC_DEC_TRANSPORT_ERROR:
            return AacDecoderResult_InputBitstreamCorrupted;
        case AAC_DEC_PARSE_ERROR:
            return AacDecoderResult_InputBitstreamCorrupted;
        case AAC_DEC_UNSUPPORTED_EXTENSION_PAYLOAD:
            return AacDecoderResult_UnsupportedFormat;
        case AAC_DEC_DECODE_FRAME_ERROR:
            return AacDecoderResult_InputBitstreamCorrupted;
        case AAC_DEC_CRC_ERROR:
            return AacDecoderResult_CrcError;
        case AAC_DEC_INVALID_CODE_BOOK:
            return AacDecoderResult_InputBitstreamCorrupted;
        case AAC_DEC_UNSUPPORTED_PREDICTION:
            return AacDecoderResult_InputBitstreamCorrupted;
        case AAC_DEC_UNSUPPORTED_CCE:
            return AacDecoderResult_InputBitstreamCorrupted;
        case AAC_DEC_UNSUPPORTED_LFE:
            return AacDecoderResult_InputBitstreamCorrupted;
        case AAC_DEC_UNSUPPORTED_GAIN_CONTROL_DATA:
            return AacDecoderResult_InputBitstreamCorrupted;
        case AAC_DEC_UNSUPPORTED_SBA:
            return AacDecoderResult_UnsupportedFormat;
        case AAC_DEC_TNS_READ_ERROR:
            return AacDecoderResult_InputBitstreamCorrupted;
        case AAC_DEC_RVLC_ERROR:  // ignore
            return AacDecoderResult_Success;
        case AAC_DEC_ANC_DATA_ERROR:  // ignore
            return AacDecoderResult_Success;
        case AAC_DEC_TOO_SMALL_ANC_BUFFER:  // ignore
            return AacDecoderResult_Success;
        case AAC_DEC_TOO_MANY_ANC_ELEMENTS:  // ignore
            return AacDecoderResult_Success;
        default:
            NN_UNEXPECTED_DEFAULT;
    }
}

}}  // namespace nn::codec
