﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>
#include <cec_TransmitterFiniteStateMachine.h>

namespace nn { namespace cec { namespace detail {

const uint32_t LowLevelInterfaceSelectDisplayPort = 0;
const uint32_t LowLevelInterfaceSelectTestMode = 1;

int32_t CecLowLevelGetHpdState(bool* pOutHpdState) NN_NOEXCEPT;
void    CecLowLevelInterfaceInitializeCecPolling() NN_NOEXCEPT;
void    CecLowLevelInterfaceFinalizeCecPolling() NN_NOEXCEPT;
void    CecLowLevelInterfaceCecCallback(void* pContext, uint8_t* buffer, uint32_t length) NN_NOEXCEPT;
void    CecLowLevelInterfaceDcCallback(void* pContext, bool isConnected) NN_NOEXCEPT;
int32_t CecLowLevelInterfaceInit(uint32_t interfaceType) NN_NOEXCEPT;
int32_t CecLowLevelInterfaceStart() NN_NOEXCEPT;
int32_t CecLowLevelInterfacePrepareForStop() NN_NOEXCEPT;
int32_t CecLowLevelInterfaceStop() NN_NOEXCEPT;
int32_t CecLowLevelInterfaceShutdown() NN_NOEXCEPT;
void    CecLowLevelInterfaceInitializeHpdChange() NN_NOEXCEPT;
bool    CecLowLevelInterfaceHasHpdChanged() NN_NOEXCEPT;
int32_t CecLowLevelInterfaceGetConnectionStatus(uint32_t* pOutHpdStatus, uint32_t* pOutSinkStatus) NN_NOEXCEPT;
int32_t CecLowLevelInterfaceLastTraffic(uint32_t* pDeltaUs) NN_NOEXCEPT;
int32_t CecLowLevelInterfaceEnable(bool enable) NN_NOEXCEPT;
int32_t CecLowLevelInterfaceGetPhysicalAddress(uint8_t* pPhysicalAddress) NN_NOEXCEPT;
int32_t CecLowLevelInterfaceSetLogicalAddress(uint8_t logicalAddress) NN_NOEXCEPT;
int32_t CecLowLevelInterfaceReadData(uint8_t* pReadBuffer, int* pReadByteCount) NN_NOEXCEPT;
int32_t CecLowLevelInterfaceTransmitData(TransmitReturnValueType* pTransmitReturnValue,
                                         uint8_t* pData, uint8_t count) NN_NOEXCEPT;

}
}   // namespace cec
}   // namespace nn
