﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>
#include <nn/nn_Common.h>
#include <nn/os/os_MutexTypes.h>

namespace nn { namespace cec { namespace detail {

void        CecCancelInitialize() NN_NOEXCEPT;
void        CecCancelFinalize() NN_NOEXCEPT;
bool        CecCancelSetCancelState(os::MutexType* pApiMutex) NN_NOEXCEPT;
bool        CecCancelClearCancelState() NN_NOEXCEPT;
bool        CecCancelSleepThreadMilliseconds(uint32_t sleepTimeInMilliseconds);
void        CecStepPseudoRandomNumberGenerator() NN_NOEXCEPT;
uint32_t    CecComputePseudoRandomBroadcastDelayInMicroSeconds() NN_NOEXCEPT;
uint64_t    CecComputeSixtyFourBitHashValue(uint8_t* pBuffer, uint32_t countBytes) NN_NOEXCEPT;

}
}   // namespace cec
}   // namespace nn
