﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "cdhidWin32Mouse_Private.h"

namespace nn {
namespace cdhid {
namespace win32 {

//////////////////////////////////////////////////////////////////////////////
ReadSession::ReadSession(Win32MouseInterface *pWin32MouseInterface, uint32_t deviceHandle) NN_NOEXCEPT
{
    m_pWin32MouseInterface  = pWin32MouseInterface;
    m_DeviceHandle          = deviceHandle;
}


//////////////////////////////////////////////////////////////////////////////
ReadSession::~ReadSession() NN_NOEXCEPT
{
}


//////////////////////////////////////////////////////////////////////////////
Result ReadSession::Read(nn::sf::OutBuffer outBuffer, nn::sf::Out<std::uint32_t> pBytesRead, nn::TimeSpan timeout) NN_NOEXCEPT
{
    NN_UNUSED(timeout);

    return m_pWin32MouseInterface->AhidRead(
                                        pBytesRead.GetPointer(),
                                        reinterpret_cast<uint8_t *>(outBuffer.GetPointerUnsafe()),
                                        static_cast<uint32_t>(outBuffer.GetSize()),
                                        timeout
                                        );
}



} // end of namespace win32
} // end of namespace cdhid
} // end of namespace nn
