﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "cdhidWin32Mouse_Private.h"

namespace nn {
namespace cdhid {
namespace win32 {

//////////////////////////////////////////////////////////////////////////////
//  public functions
//////////////////////////////////////////////////////////////////////////////
Result Win32MouseCodeBook::Initialize() NN_NOEXCEPT
{
    memset(m_CodeBook, 0, sizeof(m_CodeBook));

    uint8_t *pDst = m_CodeBook;

    nn::ahid::CodeBookHeader  *pCodeBookHeader = reinterpret_cast<nn::ahid::CodeBookHeader*>(pDst);

    pCodeBookHeader->reportCount    = 1;
    pCodeBookHeader->reportId[0]    = 0;
    pCodeBookHeader->usagePage[0]   = 0x01; // Generic Desktop
    pCodeBookHeader->usage[0]       = 0x02; // Mouse

    pCodeBookHeader->inputSize      = 4;
    pCodeBookHeader->outputSize     = 0;
    pCodeBookHeader->featureSize    = 0;

    pCodeBookHeader->inputItems     = WIN32MOUSE_INPUT_ITEMS;
    pCodeBookHeader->outputItems    = WIN32MOUSE_OUTPUT_ITEMS;
    pCodeBookHeader->featureItems   = WIN32MOUSE_FEATURE_ITEMS;

    pDst += sizeof(nn::ahid::CodeBookHeader);

    pDst += PrintItemBitmask8(pDst, 0, 0, 0x09, 0x01, 0x01, 0, 0x1, 0);    // button 1
    pDst += PrintItemBitmask8(pDst, 0, 0, 0x09, 0x02, 0x02, 0, 0x2, 1);    // button 2
    pDst += PrintItemBitmask8(pDst, 0, 0, 0x09, 0x03, 0x03, 0, 0x4, 2);    // button 3
    pDst += PrintItemLogical8(pDst, 0, 0, 0x01, 0x30, 0x30, 1, -127, 127); // X
    pDst += PrintItemLogical8(pDst, 0, 0, 0x01, 0x31, 0x31, 2, -127, 127); // Y
    pDst += PrintItemLogical8(pDst, 0, 0, 0x01, 0x38, 0x38, 3, -127, 127); // wheel

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result Win32MouseCodeBook::Finalize() NN_NOEXCEPT
{
    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result Win32MouseCodeBook::Get(uint8_t* pBuffer, size_t bufferSize) NN_NOEXCEPT
{
    if (pBuffer && (bufferSize >= sizeof(m_CodeBook)))
    {
        memcpy(pBuffer, m_CodeBook, sizeof(m_CodeBook));

        return ResultSuccess();
    }

    return nn::ahid::ResultBufferSize();
}


//////////////////////////////////////////////////////////////////////////////
//  private functions
//////////////////////////////////////////////////////////////////////////////
size_t Win32MouseCodeBook::PrintItemBitmask8(
    uint8_t*    pDst,
    uint8_t     reportId,
    uint8_t     index,
    uint16_t    usagePage,
    uint16_t    usageMin,
    uint16_t    usageMax,
    uint16_t    dataOffset,
    uint8_t     dataBits,
    uint8_t     dataShift
    )
{
    nn::ahid::ItemBitmask8 *pItemBitmask8  = reinterpret_cast<nn::ahid::ItemBitmask8*>(pDst);

    pItemBitmask8->item.type                = nn::ahid::DataType::DataType_Bitmask8;
    pItemBitmask8->item.length              = sizeof(nn::ahid::ItemBitmask8);
    pItemBitmask8->item.reportId            = reportId;
    pItemBitmask8->item.index               = index;
    pItemBitmask8->item.usagePage           = usagePage;
    pItemBitmask8->item.usageMin            = usageMin;
    pItemBitmask8->item.usageMax            = usageMax;

    pItemBitmask8->dataOffset               = dataOffset;
    pItemBitmask8->dataBits                 = dataBits;
    pItemBitmask8->dataShift                = dataShift;

    return sizeof(nn::ahid::ItemBitmask8);
}


//////////////////////////////////////////////////////////////////////////////
size_t Win32MouseCodeBook::PrintItemLogical8(
    uint8_t*    pDst,
    uint8_t     reportId,
    uint8_t     index,
    uint16_t    usagePage,
    uint16_t    usageMin,
    uint16_t    usageMax,
    uint16_t    dataOffset,
    int8_t      dataMin,
    int8_t      dataMax
    )
{
    nn::ahid::ItemLogical8 *pItemLogical8   = reinterpret_cast<nn::ahid::ItemLogical8*>(pDst);

    pItemLogical8->item.type                = nn::ahid::DataType::DataType_Logical8;
    pItemLogical8->item.length              = sizeof(nn::ahid::ItemLogical8);
    pItemLogical8->item.reportId            = reportId;
    pItemLogical8->item.index               = index;
    pItemLogical8->item.usagePage           = usagePage;
    pItemLogical8->item.usageMin            = usageMin;
    pItemLogical8->item.usageMax            = usageMax;

    pItemLogical8->dataOffset               = dataOffset;
    pItemLogical8->logicalMinimum           = dataMin;
    pItemLogical8->logicalMaximum           = dataMax;

    return sizeof(nn::ahid::ItemLogical8);
}


}   // namespace win32
}   // namespace cdhid
}   // namespace nn
