﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace cdhid {
namespace win32 {

enum
{
    WIN32KEYBOARD_INPUT_ITEMS   = 19,
    WIN32KEYBOARD_OUTPUT_ITEMS  = 0,
    WIN32KEYBOARD_FEATURE_ITEMS = 0,
};

class Win32KeyboardCodeBook
{
    NN_DISALLOW_COPY(Win32KeyboardCodeBook);
    NN_DISALLOW_MOVE(Win32KeyboardCodeBook);

public:

    Win32KeyboardCodeBook() NN_NOEXCEPT {};
    ~Win32KeyboardCodeBook() NN_NOEXCEPT {};


    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;
    Result Get(uint8_t* pBuffer, size_t bufferSize) NN_NOEXCEPT;

private:

    uint8_t m_CodeBook[sizeof(nn::ahid::CodeBookHeader) + (sizeof(nn::ahid::ItemBitmask8) * 13) + (sizeof(nn::ahid::ItemLogical8) * 6)];

    uint32_t PrintCodeBookHeader(
                                    uint8_t*    pDst,
                                    uint8_t     usage,
                                    uint8_t     usagePage,
                                    uint32_t    inputSize,
                                    uint32_t    outputSize,
                                    uint32_t    featureSize,
                                    uint32_t    decoderEntries,
                                    uint32_t    encoderEntries,
                                    uint32_t    featureEntries
                                    );

    size_t PrintItemBitmask8(
                                    uint8_t*    pDst,
                                    uint8_t     reportId,
                                    uint8_t     index,
                                    uint16_t    usagePage,
                                    uint16_t    usageMin,
                                    uint16_t    usageMax,
                                    uint16_t    dataOffset,
                                    uint8_t     dataBits,
                                    uint8_t     dataShift
                                    );

    size_t PrintItemLogical8(
                                    uint8_t*    pDst,
                                    uint8_t     reportId,
                                    uint8_t     index,
                                    uint16_t    usagePage,
                                    uint16_t    usageMin,
                                    uint16_t    usageMax,
                                    uint16_t    dataOffset,
                                    uint8_t     dataMin,
                                    uint8_t     dataMax
                                    );
};


}   // namespace win32
}   // namespace cdhid
}   // namespace nn
