﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "cdhidWin32Hid_Private.h"

namespace nn {
namespace cdhid {
namespace win32 {

//////////////////////////////////////////////////////////////////////////////
ServerSession::ServerSession(Win32HidEnum *pWin32HidEnum, nn::sf::ExpHeapAllocator *pAllocator) NN_NOEXCEPT
{
    m_pWin32HidEnum = pWin32HidEnum;
    m_pAllocator    = pAllocator;
}


//////////////////////////////////////////////////////////////////////////////
ServerSession::~ServerSession() NN_NOEXCEPT
{
}


//////////////////////////////////////////////////////////////////////////////
Result ServerSession::AcquireDevice(uint32_t deviceHandle) NN_NOEXCEPT
{
    return m_pWin32HidEnum->AcquireDevice(deviceHandle, &m_pWin32HidInterface);
}


//////////////////////////////////////////////////////////////////////////////
Result ServerSession::ReleaseDevice(uint32_t deviceHandle) NN_NOEXCEPT
{
    return m_pWin32HidEnum->ReleaseDevice(deviceHandle);
}


//////////////////////////////////////////////////////////////////////////////
Result ServerSession::GetCtrlSession(uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::ICtrlSession>> outSession) NN_NOEXCEPT
{
    Result result;

    nn::sf::SharedPointer<nn::ahid::ICtrlSession> session;

    session = Factory::CreateSharedEmplaced<nn::ahid::ICtrlSession, CtrlSession>(m_pAllocator, m_pWin32HidInterface, deviceHandle);

    if (session)
    {
        // set ctrl session to interface for state change signal
        m_pWin32HidInterface->SetCtrlSession(session);

        *outSession = std::move(session);
        result = ResultSuccess();
    }
    else
    {
        result = nn::ahid::ResultMemAllocFailure();
    }

    return result;
}


//////////////////////////////////////////////////////////////////////////////
Result ServerSession::GetReadSession(uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::IReadSession>> outSession) NN_NOEXCEPT
{
    Result result;

    nn::sf::SharedPointer<nn::ahid::IReadSession> session;

    session = Factory::CreateSharedEmplaced<nn::ahid::IReadSession, ReadSession>(m_pAllocator, m_pWin32HidInterface, deviceHandle);

    if (session)
    {
        *outSession = std::move(session);
        result = ResultSuccess();
    }
    else
    {
        result = nn::ahid::ResultMemAllocFailure();
    }

    return result;
}


} // end of namespace win32
} // end of namespace cdhid
} // end of namespace nn
