﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    cdhidWin32Hid_Private.h
 * @brief   cdhidWin32Hid private includes
 */
#include <cstdio>
#include <cstring>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/util/util_IntrusiveList.h>

#include <nn/os.h>
#include <nn/os/os_SdkThreadCommon.h>
#include <nn/os/os_Thread.h>
#include <nn/os/os_InterruptEvent.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_MemoryFence.h>

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/impl/sf_StaticOneAllocator.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_NativeHandle.h>

#include <nn/nn_Windows.h>

extern "C"
{
#include <hidsdi.h>

NN_PRAGMA_PUSH_WARNINGS
NN_DISABLE_WARNING_FROM_WINDOWS_SDK_HEADERS
#include <SetupApi.h>
NN_PRAGMA_POP_WARNINGS
}

#include <nn/ahid/hdr/hdr.h>

#include <nn/ahid/sfdl/IServerSession.sfdl.h>
#include <nn/ahid/sfdl/ICtrlSession.sfdl.h>
#include <nn/ahid/sfdl/IReadSession.sfdl.h>

#include "cdhidWin32Hid_Interface.h"
#include "cdhidWin32Hid_Enum.h"
#include "cdhidWin32Hid_CtrlSession.h"
#include "cdhidWin32Hid_ReadSession.h"
#include "cdhidWin32Hid_ServerSession.h"
#include "cdhidWin32Hid_Server.h"

#include <nn/ahid/ahid_ResultPrivate.h>
#include <nn/ahid/ahid_ResultPublic.h>
