﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

#include "cal_Settings.h"

namespace nn { namespace cal {

//!< 領域拡張されたデバイス登録用秘密鍵（ECC-B233 版）を暗号化します。
::nn::Result EncryptExtendedEccB233DeviceKey(CalibrationInfo* pOutValue) NN_NOEXCEPT;

//!< 領域拡張されたデバイス登録用秘密鍵（RSA-2048 版）を暗号化します。
::nn::Result EncryptExtendedRsa2048DeviceKey(CalibrationInfo* pOutValue) NN_NOEXCEPT;

//!< 領域拡張された eTicket 発行用秘密鍵（RSA-2048 版）を暗号化します。
::nn::Result EncryptExtendedRsa2048ETicketKey(CalibrationInfo* pOutValue) NN_NOEXCEPT;

//!< 領域拡張された SSL クライアント秘密鍵を暗号化します。
::nn::Result EncryptExtendedSslKey(CalibrationInfo* pOutValue) NN_NOEXCEPT;

//!< 領域拡張されたゲームカード相互認証秘密鍵を暗号化します。
::nn::Result EncryptExtendedGameCardKey(CalibrationInfo* pOutValue) NN_NOEXCEPT;

//!< amiibo 用本体秘密鍵を暗号化します。
::nn::Result EncryptAmiiboKey(CalibrationInfo* pOutValue) NN_NOEXCEPT;

//!< amiibo 用 ECQV-BLS 本体秘密鍵を暗号化します。
::nn::Result EncryptAmiiboEcqvBlsKey(CalibrationInfo* pOutValue) NN_NOEXCEPT;

}}
