﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/bpc/bpc_PowerButtonTypes.h>

namespace nn { namespace bpc { namespace driver { namespace detail {

enum MessageOnOff
{
    MessageOnOff_Finalize = 0x400,
    MessageOnOff_Rising,
    MessageOnOff_Falling,
    MessageOnOff_1sec,
    MessageOnOff_ManualResetWarning,
    MessageOnOff_Update,
};

void InitializeSleepButtonCounter() NN_NOEXCEPT;
void FinalizeSleepButtonCounter() NN_NOEXCEPT;
nn::os::MessageQueueType* GetSleepButtonCounterMessageQueue() NN_NOEXCEPT;
void GetSleepButtonState(SleepButtonState* pOutState) NN_NOEXCEPT;
void StartSleepButtonStateUpdate() NN_NOEXCEPT;
void GetPowerButtonEventPtr(nn::os::SystemEventType** pOutEventPtr, EventTarget target) NN_NOEXCEPT;

}}}} // namespace nn::bpc::driver::detail
