﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/bpc/bpc_BoardPowerControlTypes.h>

namespace nn { namespace bpc { namespace driver { namespace detail {

void InitializePowerReason() NN_NOEXCEPT;
void ConfigWakeupEvents() NN_NOEXCEPT;
void UpdateWakeupReason() NN_NOEXCEPT; // clear on read なレジスタを読むので起床後一度しか呼ばないこと
nn::Result GetWakeupReason(WakeupReason* pOutWakeupReason) NN_NOEXCEPT;
nn::Result GetShutdownReason(ShutdownReason* pOutShutdownReason) NN_NOEXCEPT;

}}}} // namespace nn::bpc::driver::detail
