﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_Types.h>
#include <nn/bpc/bpc_IBoardPowerControlManager.sfdl.h>
#include <nn/bpc/bpc_IRtcManager.sfdl.h>

namespace nn { namespace bpc {

// 実装オブジェクトに HIPC を介してアクセスする場合に、Manager への参照を取得する関数
// 別途 サーバーが立ち上がっている必要がある。
nn::sf::SharedPointer<nn::bpc::IBoardPowerControlManager> GetBoardPowerControlManagerByHipc() NN_NOEXCEPT;
nn::sf::SharedPointer<nn::bpc::IRtcManager> GetRtcManagerByHipc() NN_NOEXCEPT;

}} // namespace nn::bpc
