﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/bgsu/bgsu_MultiClientSystemEvent.h>

#include "bgtc_Common.h"

namespace nn { namespace bgtc {

class StateControlServiceImpl
{
public:
    StateControlServiceImpl();
    ~StateControlServiceImpl();

    nn::Result GetState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT;
    nn::Result GetStateChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result NotifyEnteringHalfAwake() NN_NOEXCEPT;
    nn::Result NotifyLeavingHalfAwake() NN_NOEXCEPT;
    nn::Result SetIsUsingSleepUnsupportedDevices(bool bIsUsing) NN_NOEXCEPT;

private:
    bgsu::MultiClientSystemEvent::Node m_StateChangeEventNode;
};

}}
