﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_ContextControl.h>

#include "bgtc_Instance.h"
#include "bgtc_CompositeEventHandlerThread.h"
#include "bgtc_StateControlServiceImpl.h"

namespace nn { namespace bgtc {

StateControlServiceImpl::StateControlServiceImpl()
    : m_StateChangeEventNode(os::EventClearMode_AutoClear, true)
{
    g_Instance.GetCompositeEventHandlerThread().AttachStateChangeEvent(&m_StateChangeEventNode);
}

StateControlServiceImpl::~StateControlServiceImpl()
{
    g_Instance.GetCompositeEventHandlerThread().DetachStateChangeEvent(&m_StateChangeEventNode);
}

nn::Result StateControlServiceImpl::GetState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT
{
    outState.Set(static_cast<int32_t>(g_Instance.GetCompositeEventHandlerThread().GetState()));
    return ResultSuccess();
}

nn::Result StateControlServiceImpl::GetStateChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
{
    outHandle.Set(nn::sf::NativeHandle(m_StateChangeEventNode.GetReadableHandle(), false));
    return ResultSuccess();
}

nn::Result StateControlServiceImpl::NotifyEnteringHalfAwake() NN_NOEXCEPT
{
    g_Instance.GetCompositeEventHandlerThread().TriggerEvent(CompositeEventHandlerThread::EventCode_EnteringHalfAwake);
    return ResultSuccess();
}

nn::Result StateControlServiceImpl::NotifyLeavingHalfAwake() NN_NOEXCEPT
{
    g_Instance.GetCompositeEventHandlerThread().TriggerEvent(CompositeEventHandlerThread::EventCode_LeavingHalfAwake);
    return ResultSuccess();
}

nn::Result StateControlServiceImpl::SetIsUsingSleepUnsupportedDevices(bool bIsUsing) NN_NOEXCEPT
{
    g_Instance.GetCompositeEventHandlerThread().SetIsUsingSleepUnsupportedDevices(bIsUsing);
    return ResultSuccess();
}

}}
