﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#include "bgtc_Config.h"

#define NN_BGTC_LOG(...)                NN_DETAIL_STRUCTURED_SDK_LOG(bgtc, Info,  0, ##__VA_ARGS__)
#define NN_BGTC_FATAL(...)              NN_DETAIL_STRUCTURED_SDK_LOG(bgtc, Fatal, 0, ##__VA_ARGS__)
#define NN_BGTC_ERROR(...)              NN_DETAIL_STRUCTURED_SDK_LOG(bgtc, Error, 0, ##__VA_ARGS__)
#define NN_BGTC_WARN(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bgtc, Warn,  0, ##__VA_ARGS__)
#define NN_BGTC_INFO(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bgtc, Info,  0, ##__VA_ARGS__)

#if NN_BGTC_ENABLE_LOG_VERBOSE
#define NN_BGTC_TRACE(...)              NN_DETAIL_STRUCTURED_SDK_LOG(bgtc, Trace, 0, ##__VA_ARGS__)
#define NN_BGSU_ENABLE_FUNCTION_TRACE   1                                               // NOLINT(preprocessor/const)
#else
#define NN_NPNS_TRACE(...)              (void)0
#define NN_BGSU_ENABLE_FUNCTION_TRACE   0                                               // NOLINT(preprocessor/const)
#endif

#include <nn/bgsu/bgsu_Log.h>
