﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/sf/sf_HipcServer.h>

#include "bgtc_Common.h"

namespace nn { namespace bgtc {

struct IpcServerManagerOption
{
    static const size_t PointerTransferBufferSize = 256;
    static const bool CanDeferInvokeRequest = true;
};

const int SessionCountPerPort = 30;


class IpcServerManager
    : public nn::sf::HipcSimpleAllInOneServerManager<SessionCountPerPort * 2, 2, IpcServerManagerOption>
{
public:
    IpcServerManager();
    ~IpcServerManager();

    void Initialize();
    void Finalize();

private:

    virtual nn::Result OnNeedsToAccept(int portIndex, PortObjectImpl* pPort) NN_NOEXCEPT NN_OVERRIDE;
};

}}
