﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/bcat/detail/service/bcat_DeliveryCacheProgressService.generic.h>
#include <nn/bcat/bcat_Result.h>
#include <nn/bcat/detail/bcat_Log.h>

namespace nn { namespace bcat { namespace detail { namespace service {

DeliveryCacheProgressServiceForGeneric::DeliveryCacheProgressServiceForGeneric() NN_NOEXCEPT :
    m_Event(nn::os::EventClearMode_ManualClear, true)
{
}

DeliveryCacheProgressServiceForGeneric::~DeliveryCacheProgressServiceForGeneric() NN_NOEXCEPT
{
}

nn::Result DeliveryCacheProgressServiceForGeneric::GetEvent(nn::sf::Out<nn::sf::NativeHandle> outEvent) NN_NOEXCEPT
{
    outEvent.Set(nn::sf::NativeHandle(m_Event.DetachReadableHandle(), true));

    NN_RESULT_SUCCESS;
}

nn::Result DeliveryCacheProgressServiceForGeneric::GetImpl(nn::sf::Out<nn::bcat::detail::DeliveryCacheProgressImpl> outImpl) NN_NOEXCEPT
{
    DeliveryCacheProgressImpl progress = {};

    progress.status = DeliveryCacheProgressStatusImpl_Done;

    *outImpl = progress;

    NN_RESULT_SUCCESS;
}

}}}}
