﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/bcat/detail/service/bcat_DeliveryCacheProgressService.h>
#include <nn/bcat/detail/service/core/bcat_DeliveryCacheProgressManager.h>
#include <nn/bcat/detail/service/core/bcat_SessionManager.h>
#include <nn/bcat/detail/service/core/bcat_BackgroundWorkerThread.h>

namespace nn { namespace bcat { namespace detail { namespace service {

DeliveryCacheProgressService::DeliveryCacheProgressService(SessionId sessionId, TaskId taskId, const Capability& capability) NN_NOEXCEPT :
    m_Capability(capability),
    m_SessionId(sessionId),
    m_TaskId(taskId),
    m_Event(nn::os::EventClearMode_ManualClear, true)
{
    NN_UNUSED(m_Capability);
}

DeliveryCacheProgressService::~DeliveryCacheProgressService() NN_NOEXCEPT
{
    detail::service::core::DeliveryCacheProgressManager::GetInstance().Unregister(m_TaskId);

    detail::service::core::SessionManager::GetInstance().RemoveTask(m_SessionId, m_TaskId);
}

nn::Result DeliveryCacheProgressService::GetEvent(nn::sf::Out<nn::sf::NativeHandle> outEvent) NN_NOEXCEPT
{
    outEvent.Set(nn::sf::NativeHandle(m_Event.DetachReadableHandle(), true));

    detail::service::core::DeliveryCacheProgressManager::GetInstance().AttachUpdateDetectionEvent(m_TaskId, m_Event.GetWritableHandle());

    NN_RESULT_SUCCESS;
}

nn::Result DeliveryCacheProgressService::GetImpl(nn::sf::Out<nn::bcat::detail::DeliveryCacheProgressImpl> outImpl) NN_NOEXCEPT
{
    detail::service::core::BackgroundWorkerThread::GetProgress(outImpl.GetPointer(), m_TaskId);

    NN_RESULT_SUCCESS;
}

}}}}
