﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/bcat/bcat_Types.h>

namespace nn { namespace bcat {

bool FileName::IsValid() const NN_NOEXCEPT
{
    int length = 0;

    for (int i = 0; i < sizeof (value); i++)
    {
        char c = value[i];

        if (c == '\0')
        {
            break;
        }

        // a-zA-Z0-9_.
        if (!((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || (c >= '0' && c <= '9') || (c == '_') || (c == '.')))
        {
            return false;
        }

        length++;
    }

    if (length == 0 || length == sizeof (value))
    {
        return false;
    }
    if (value[length] != '\0')
    {
        return false;
    }
    if (value[length - 1] == '.')
    {
        return false;
    }

    return true;
}

bool DirectoryName::IsValid() const NN_NOEXCEPT
{
    int length = 0;

    for (int i = 0; i < sizeof (value); i++)
    {
        char c = value[i];

        if (c == '\0')
        {
            break;
        }

        // a-zA-Z0-9_-
        if (!((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || (c >= '0' && c <= '9') || (c == '_') || (c == '-')))
        {
            return false;
        }

        length++;
    }

    if (length == 0 || length == sizeof (value))
    {
        return false;
    }
    if (value[length] != '\0')
    {
        return false;
    }

    return true;
}

}}
