﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Event.h>
#include <nn/os/os_TimerEvent.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/audioctrl/audioctrl_AudioControllerTypes.h>
#include "audioctrl_GpioInterruptHandler.h"
#include "audioctrl_OverlaySenderController.h"

namespace nn { namespace audioctrl { namespace server { namespace detail {

class UserInputHandler
{
    NN_DISALLOW_COPY( UserInputHandler );
    NN_DISALLOW_MOVE( UserInputHandler );

private:
    nn::os::TimerEvent m_ButtonRepeatTimerEvent;
    nn::os::TimerEvent m_HeadphoneMicJackDetectTimerEvent;
    nn::os::TimerEvent m_VolumeSettingsSaveTimerEvent;
    nn::os::SystemEvent* m_pHeadphoneMicJackDetectEvent;
    nn::os::SystemEventType  m_HidAudioControlStateChangeEvent;
    GpioInterruptHandler m_ButtonUpHandler;
    GpioInterruptHandler m_ButtonDownHandler;
    std::atomic_bool m_IsHeadphoneJackDetectionEnabled;
    std::atomic_bool m_IsVolumeButtonEnabled;
    std::atomic_bool m_IsAwake;
    AudioTarget m_PreviousTarget;
    int64_t m_HidAudioControlStateLatestSamplingNumber;

    bool IsHeadphoneMicJackInserted() NN_NOEXCEPT;

    AudioTarget GetCurrentTarget() NN_NOEXCEPT;
    void SwitchTarget(AudioTarget targetFrom, AudioTarget targetTo) NN_NOEXCEPT;
public:
    UserInputHandler() NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void Sleep() NN_NOEXCEPT;
    void Wake() NN_NOEXCEPT;
    void Handler() NN_NOEXCEPT;
    void VolumeButtonHandler() NN_NOEXCEPT;
    void VolumeButtonTimerEventHandler() NN_NOEXCEPT;
    void HeadphoneJackDetectEventHandler() NN_NOEXCEPT;
    void HeadphoneJackDetectTimerEventHandler() NN_NOEXCEPT;
    void VolumeSettingsSaveTimerEventHandler() NN_NOEXCEPT;
    void UacSpeakerAttachHandler() NN_NOEXCEPT;
    void UacSpeakerDetachHandler() NN_NOEXCEPT;
    void UacUnsupportedSpeakerAttachHandler() NN_NOEXCEPT;
    void HidAudioControlStateChangeEventHandler() NN_NOEXCEPT;
    void SetHeadphoneJackDetectionEnabled(bool isEnabled) NN_NOEXCEPT;
    bool IsHeadphoneJackDetectionEnabled() const NN_NOEXCEPT;
    void SetVolumeButtonEnabled(bool isEnabled) NN_NOEXCEPT;
    bool IsVolumeButtonEnabled() const NN_NOEXCEPT;
    nn::os::EventType* GetUacSpeakerAttachEvent() NN_NOEXCEPT;
    nn::os::EventType* GetUacSpeakerDetachEvent() NN_NOEXCEPT;
    nn::os::SystemEventType& GetButtonUpEvent() NN_NOEXCEPT;
    nn::os::SystemEventType& GetButtonDownEvent() NN_NOEXCEPT;
    nn::os::TimerEvent& GetButtonRepeatTimerEvent() NN_NOEXCEPT;
    nn::os::SystemEvent& GetHeadpphoneJackDetect() NN_NOEXCEPT;
    nn::os::TimerEvent& GetHeadphoneJackDetectTimerEvent() NN_NOEXCEPT;
    nn::os::TimerEvent& GetVolumeSettingsTimerEvent() NN_NOEXCEPT;
    nn::os::SystemEventType& GetHidAudioControlChangeEvent() NN_NOEXCEPT;
    nn::os::EventType* GetUacUnsupportedSpeakerAttachEvent() NN_NOEXCEPT;
};

}}}}  // namespace nn::audioctrl::server::detail
