﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include "audioctrl_CreateAudioController.h"
#include "audioctrl_ServiceName.h"
#include "../server/detail/audioctrl_AudioControllerImpl.h"

namespace nn { namespace audioctrl { namespace detail {

namespace {

struct CreateAudioControllerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateAudioControllerByHipcTag> MyAllocator;

class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_MyAllocatorInitializer;

}  // namespace anonymous

nn::sf::SharedPointer<detail::IAudioController> CreateAudioControllerByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IAudioController> ret;
    auto result = nn::sf::CreateHipcProxyByName<detail::IAudioController, MyAllocator::Policy>(&ret, AudioControllerServiceName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return ret;
}

}}}  // namespace nn::audioctrl::detail
