﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include <nn/audio/detail/audio_IAudioRendererManager.h>
#include "audio_CreateAudioRendererManager.h"
#include "audio_ServiceName.h"
#include "../server/audio_AudioRendererManagerImpl.h"
#include "../server/audio_AudioRendererManagerForAppletImpl.h"
#include "../server/audio_AudioRendererManagerForDebuggerImpl.h"
#include "../common/audio_BuildDefinition.h"

namespace nn {
namespace audio {

nn::sf::UnmanagedServiceObject<detail::IAudioRendererManager, server::AudioRendererManagerImpl> g_AudioRendererManager;
#if defined(NN_AUDIO_SYSTEM_PROCESS)
nn::sf::UnmanagedServiceObject<detail::IAudioRendererManagerForDebugger, server::AudioRendererManagerForDebuggerImpl> g_AudioRendererManagerForDebugger;
nn::sf::UnmanagedServiceObject<detail::IAudioRendererManagerForApplet, server::AudioRendererManagerForAppletImpl> g_AudioRendererManagerForApplet;
#endif

nn::sf::SharedPointer<detail::IAudioRendererManager> CreateAudioRendererManagerByDfc() NN_NOEXCEPT
{
    return g_AudioRendererManager.GetShared();
}

#if defined(NN_AUDIO_SYSTEM_PROCESS)
nn::sf::SharedPointer<detail::IAudioRendererManagerForApplet> CreateAudioRendererManagerForAppletByDfc() NN_NOEXCEPT
{
    return g_AudioRendererManagerForApplet.GetShared();
}

nn::sf::SharedPointer<detail::IAudioRendererManagerForDebugger> CreateAudioRendererManagerForDebuggerByDfc() NN_NOEXCEPT
{
    return g_AudioRendererManagerForDebugger.GetShared();
}
#endif

}  // namespace audio
}  // namespace nn
