﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_Types.h>
#include <nn/audio/detail/audio_IAudioOutManager.h>
#include <nn/audio/detail/audio_IAudioOutManagerForApplet.h>
#include <nn/audio/detail/audio_IAudioOutManagerForDebugger.h>

namespace nn {
namespace audio {

nn::sf::SharedPointer<detail::IAudioOutManager> CreateAudioOutManagerByDfc() NN_NOEXCEPT;
nn::sf::SharedPointer<detail::IAudioOutManager> CreateAudioOutManagerByHipc() NN_NOEXCEPT;
nn::sf::SharedPointer<detail::IAudioOutManagerForDebugger> CreateAudioOutManagerForDebuggerByDfc() NN_NOEXCEPT;
nn::sf::SharedPointer<detail::IAudioOutManagerForDebugger> CreateAudioOutManagerForDebuggerByHipc() NN_NOEXCEPT;
nn::sf::SharedPointer<detail::IAudioOutManagerForApplet> CreateAudioOutManagerForAppletByDfc() NN_NOEXCEPT;
nn::sf::SharedPointer<detail::IAudioOutManagerForApplet> CreateAudioOutManagerForAppletByHipc() NN_NOEXCEPT;

}  // namespace audio
}  // namespace nn
