﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Applet;
using nn;
using nn.sf;
using std;

namespace nn.audio
{
    [CppRefPath(@"<nn/audio/audio_AudioOutTypes.h>")]
    [ExternalStruct(8, 4)]
    public struct AudioOutParameter
    {
    }
}

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nn.audio.detail
{
    [CppRefPath("<nn/audio/detail/audio_AudioOutTypesInternal.h>")]
    public struct AudioOutParameterInternal
    {
        public int32_t sampleRate;
        public int32_t channelCount;
        public int32_t sampleFormat;
        public int32_t state;
    }

    [CppRefPath(@"<nn/audio/detail/audio_IAudioOut.h>")]
    interface IAudioOut : IServiceObject
    {
        [MethodId(0)]
        Result GetAudioOutState(Out<uint32_t> outAudioOut);

        [MethodId(1)]
        Result Start();

        [MethodId(2)]
        Result Stop();

        [MethodId(3)]
        Result AppendAudioOutBuffer(InBuffer outAudioBuffer, uint64_t outBufferClientPtr);

        // This event will be signaled when there are released buffers to retrieve.
        [MethodId(4)]
        Result RegisterBufferEvent(Out<NativeHandle> bufferEvent);

        // Return all released buffers in a single call.
        [MethodId(5)]
        Result GetReleasedAudioOutBuffers(OutBuffer outAudioBuffer, Out<int> count);

        [MethodId(6)]
        Result ContainsAudioOutBuffer(uint64_t audioBufferPointer, Out<bool> contains);

        [MethodId(7)]
        Result AppendAudioOutBufferAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]InBuffer outAudioBuffer,
                                    uint64_t outBufferClientPtr);

        [MethodId(8)]
        Result GetReleasedAudioOutBuffersAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]OutBuffer outAudioBuffer,
                                            Out<int> count);

        [MethodId(9)]
        Result GetAudioOutBufferCount(Out<int> outAudioOutBufferCount);

        [MethodId(10)]
        Result GetAudioOutPlayedSampleCount(Out<int64_t> outAudioOutPlayedSampleCount);

        [MethodId(11)]
        Result FlushAudioOutBuffers(Out<bool> isAllBufferFlushed);

        [MethodId(12)]
        Result SetAudioOutVolume(float volume);

        [MethodId(13)]
        Result GetAudioOutVolume(Out<float> volume);
    }

    [CppRefPath(@"<nn/audio/detail/audio_IAudioOutManager.h>")]
    interface IAudioOutManager : IServiceObject
    {
        [MethodId(0)]
        Result ListAudioOuts(OutBuffer outAudioOut, Out<int> amountRet);

        // If the name is "", then it is the default output.
        // If sampleRate is 0, then it is the default sample rate.
        [MethodId(1)]
        Result OpenAudioOut(Out<IAudioOut> outAudioOut, InBuffer nameIn, nn.audio.AudioOutParameter param, NativeHandle processHandle, Out<nn.audio.detail.AudioOutParameterInternal> audioOutInter, OutBuffer nameOut, nn.applet.CheckedAppletResourceUserId appletId);

        [MethodId(2)]
        Result ListAudioOutsAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]OutBuffer outAudioOut,
                                    Out<int> amountRet);

        // If the name is "", then it is the default output.
        // If sampleRate is 0, then it is the default sample rate.
        [MethodId(3)]
        Result OpenAudioOutAuto(Out<IAudioOut> outAudioOut,
                                [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]InBuffer nameIn,
                                nn.audio.AudioOutParameter param,
                                NativeHandle processHandle,
                                Out<nn.audio.detail.AudioOutParameterInternal> audioOutInter,
                                [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]OutBuffer nameOut,
                                nn.applet.CheckedAppletResourceUserId appletId);
    }

    [CppRefPath(@"<nn/audio/detail/audio_IAudioOutManagerForApplet.h>")]
    interface IAudioOutManagerForApplet : IServiceObject
    {
        [MethodId(0)]
        Result RequestSuspend(nn.applet.AppletResourceUserId id, int64_t fadeTimeNanoSeconds);

        [MethodId(1)]
        Result RequestResume(nn.applet.AppletResourceUserId id, int64_t fadeTimeNanoSeconds);

        [MethodId(2)]
        Result GetProcessMasterVolume(Out<float> pOutVolume, nn.applet.AppletResourceUserId id);

        [MethodId(3)]
        Result SetProcessMasterVolume(nn.applet.AppletResourceUserId id, float volume, int64_t fadeTimeNanoSeconds);

        [MethodId(4)]
        Result GetProcessRecordVolume(Out<float> pOutVolume, nn.applet.AppletResourceUserId id);

        [MethodId(5)]
        Result SetProcessRecordVolume(nn.applet.AppletResourceUserId id, float volume, int64_t fadeTimeNanoSeconds);
    }

    [CppRefPath(@"<nn/audio/detail/audio_IAudioOutManagerForDebugger.h>")]
    interface IAudioOutManagerForDebugger : IServiceObject
    {
        [MethodId(0)]
        Result RequestSuspend(nn.applet.AppletResourceUserId id);

        [MethodId(1)]
        Result RequestResume(nn.applet.AppletResourceUserId id);
    }
}

